<?php
/**
 * Fonts class
 *
 * @author Jegstudio
 * @since 1.0.0
 * @package gutenverse
 */

namespace Gutenverse;

/**
 * Class Fonts
 *
 * @package gutenverse
 */
class Fonts {

	/**
	 * System font
	 */
	const SYSTEM_FONT = 'system';

	/**
	 * Google Font
	 */
	const GOOGLE_FONT = 'google';

	/**
	 * Fonts constructor.
	 */
	public function __construct() {
	}

	/**
	 * Font Groups
	 */
	public function get_font_groups() {
		$groups = array(
			self::SYSTEM_FONT => __( 'System', 'gutenverse' ),
			self::GOOGLE_FONT => __( 'Google', 'gutenverse' ),
		);

		return apply_filters( 'gutenverse_font_groups', $groups );
	}

	/**
	 * Get fonts
	 */
	public function get_fonts() {
		$fonts = array(
			// System fonts.
			'Arial'                          => self::SYSTEM_FONT,
			'Tahoma'                         => self::SYSTEM_FONT,
			'Verdana'                        => self::SYSTEM_FONT,
			'Helvetica'                      => self::SYSTEM_FONT,
			'Times New Roman'                => self::SYSTEM_FONT,
			'Trebuchet MS'                   => self::SYSTEM_FONT,
			'Georgia'                        => self::SYSTEM_FONT,

			// Google Fonts (last update: 23/10/2018).
			'ABeeZee'                        => self::GOOGLE_FONT,
			'Abel'                           => self::GOOGLE_FONT,
			'Abhaya Libre'                   => self::GOOGLE_FONT,
			'Abril Fatface'                  => self::GOOGLE_FONT,
			'Aclonica'                       => self::GOOGLE_FONT,
			'Acme'                           => self::GOOGLE_FONT,
			'Actor'                          => self::GOOGLE_FONT,
			'Adamina'                        => self::GOOGLE_FONT,
			'Advent Pro'                     => self::GOOGLE_FONT,
			'Aguafina Script'                => self::GOOGLE_FONT,
			'Akronim'                        => self::GOOGLE_FONT,
			'Aladin'                         => self::GOOGLE_FONT,
			'Aldrich'                        => self::GOOGLE_FONT,
			'Alef'                           => self::GOOGLE_FONT,
			'Alegreya'                       => self::GOOGLE_FONT,
			'Alegreya SC'                    => self::GOOGLE_FONT,
			'Alegreya Sans'                  => self::GOOGLE_FONT,
			'Alegreya Sans SC'               => self::GOOGLE_FONT,
			'Alex Brush'                     => self::GOOGLE_FONT,
			'Alfa Slab One'                  => self::GOOGLE_FONT,
			'Alice'                          => self::GOOGLE_FONT,
			'Alike'                          => self::GOOGLE_FONT,
			'Alike Angular'                  => self::GOOGLE_FONT,
			'Allan'                          => self::GOOGLE_FONT,
			'Allerta'                        => self::GOOGLE_FONT,
			'Allerta Stencil'                => self::GOOGLE_FONT,
			'Allura'                         => self::GOOGLE_FONT,
			'Almendra'                       => self::GOOGLE_FONT,
			'Almendra Display'               => self::GOOGLE_FONT,
			'Almendra SC'                    => self::GOOGLE_FONT,
			'Amarante'                       => self::GOOGLE_FONT,
			'Amaranth'                       => self::GOOGLE_FONT,
			'Amatic SC'                      => self::GOOGLE_FONT,
			'Amethysta'                      => self::GOOGLE_FONT,
			'Amiko'                          => self::GOOGLE_FONT,
			'Amiri'                          => self::GOOGLE_FONT,
			'Amita'                          => self::GOOGLE_FONT,
			'Anaheim'                        => self::GOOGLE_FONT,
			'Andada'                         => self::GOOGLE_FONT,
			'Andika'                         => self::GOOGLE_FONT,
			'Angkor'                         => self::GOOGLE_FONT,
			'Annie Use Your Telescope'       => self::GOOGLE_FONT,
			'Anonymous Pro'                  => self::GOOGLE_FONT,
			'Antic'                          => self::GOOGLE_FONT,
			'Antic Didone'                   => self::GOOGLE_FONT,
			'Antic Slab'                     => self::GOOGLE_FONT,
			'Anton'                          => self::GOOGLE_FONT,
			'Arapey'                         => self::GOOGLE_FONT,
			'Arbutus'                        => self::GOOGLE_FONT,
			'Arbutus Slab'                   => self::GOOGLE_FONT,
			'Architects Daughter'            => self::GOOGLE_FONT,
			'Archivo'                        => self::GOOGLE_FONT,
			'Archivo Black'                  => self::GOOGLE_FONT,
			'Archivo Narrow'                 => self::GOOGLE_FONT,
			'Aref Ruqaa'                     => self::GOOGLE_FONT,
			'Arima Madurai'                  => self::GOOGLE_FONT,
			'Arimo'                          => self::GOOGLE_FONT,
			'Arizonia'                       => self::GOOGLE_FONT,
			'Armata'                         => self::GOOGLE_FONT,
			'Arsenal'                        => self::GOOGLE_FONT,
			'Artifika'                       => self::GOOGLE_FONT,
			'Arvo'                           => self::GOOGLE_FONT,
			'Arya'                           => self::GOOGLE_FONT,
			'Asap'                           => self::GOOGLE_FONT,
			'Asap Condensed'                 => self::GOOGLE_FONT,
			'Asar'                           => self::GOOGLE_FONT,
			'Asset'                          => self::GOOGLE_FONT,
			'Assistant'                      => self::GOOGLE_FONT,
			'Astloch'                        => self::GOOGLE_FONT,
			'Asul'                           => self::GOOGLE_FONT,
			'Athiti'                         => self::GOOGLE_FONT,
			'Atma'                           => self::GOOGLE_FONT,
			'Atomic Age'                     => self::GOOGLE_FONT,
			'Aubrey'                         => self::GOOGLE_FONT,
			'Audiowide'                      => self::GOOGLE_FONT,
			'Autour One'                     => self::GOOGLE_FONT,
			'Average'                        => self::GOOGLE_FONT,
			'Average Sans'                   => self::GOOGLE_FONT,
			'Averia Gruesa Libre'            => self::GOOGLE_FONT,
			'Averia Libre'                   => self::GOOGLE_FONT,
			'Averia Sans Libre'              => self::GOOGLE_FONT,
			'Averia Serif Libre'             => self::GOOGLE_FONT,
			'Bad Script'                     => self::GOOGLE_FONT,
			'Bahiana'                        => self::GOOGLE_FONT,
			'Bai Jamjuree'                   => self::GOOGLE_FONT,
			'Baloo'                          => self::GOOGLE_FONT,
			'Baloo Bhai'                     => self::GOOGLE_FONT,
			'Baloo Bhaijaan'                 => self::GOOGLE_FONT,
			'Baloo Bhaina'                   => self::GOOGLE_FONT,
			'Baloo Chettan'                  => self::GOOGLE_FONT,
			'Baloo Da'                       => self::GOOGLE_FONT,
			'Baloo Paaji'                    => self::GOOGLE_FONT,
			'Baloo Tamma'                    => self::GOOGLE_FONT,
			'Baloo Tammudu'                  => self::GOOGLE_FONT,
			'Baloo Thambi'                   => self::GOOGLE_FONT,
			'Balthazar'                      => self::GOOGLE_FONT,
			'Bangers'                        => self::GOOGLE_FONT,
			'Barlow'                         => self::GOOGLE_FONT,
			'Barlow Condensed'               => self::GOOGLE_FONT,
			'Barlow Semi Condensed'          => self::GOOGLE_FONT,
			'Barrio'                         => self::GOOGLE_FONT,
			'Basic'                          => self::GOOGLE_FONT,
			'Battambang'                     => self::GOOGLE_FONT,
			'Baumans'                        => self::GOOGLE_FONT,
			'Bayon'                          => self::GOOGLE_FONT,
			'Belgrano'                       => self::GOOGLE_FONT,
			'Bellefair'                      => self::GOOGLE_FONT,
			'Belleza'                        => self::GOOGLE_FONT,
			'BenchNine'                      => self::GOOGLE_FONT,
			'Bentham'                        => self::GOOGLE_FONT,
			'Berkshire Swash'                => self::GOOGLE_FONT,
			'Bevan'                          => self::GOOGLE_FONT,
			'Bigelow Rules'                  => self::GOOGLE_FONT,
			'Bigshot One'                    => self::GOOGLE_FONT,
			'Bilbo'                          => self::GOOGLE_FONT,
			'Bilbo Swash Caps'               => self::GOOGLE_FONT,
			'BioRhyme'                       => self::GOOGLE_FONT,
			'BioRhyme Expanded'              => self::GOOGLE_FONT,
			'Biryani'                        => self::GOOGLE_FONT,
			'Bitter'                         => self::GOOGLE_FONT,
			'Black And White Picture'        => self::GOOGLE_FONT,
			'Black Han Sans'                 => self::GOOGLE_FONT,
			'Black Ops One'                  => self::GOOGLE_FONT,
			'Bokor'                          => self::GOOGLE_FONT,
			'Bonbon'                         => self::GOOGLE_FONT,
			'Boogaloo'                       => self::GOOGLE_FONT,
			'Bowlby One'                     => self::GOOGLE_FONT,
			'Bowlby One SC'                  => self::GOOGLE_FONT,
			'Brawler'                        => self::GOOGLE_FONT,
			'Bree Serif'                     => self::GOOGLE_FONT,
			'Bubblegum Sans'                 => self::GOOGLE_FONT,
			'Bubbler One'                    => self::GOOGLE_FONT,
			'Buda'                           => self::GOOGLE_FONT,
			'Buenard'                        => self::GOOGLE_FONT,
			'Bungee'                         => self::GOOGLE_FONT,
			'Bungee Hairline'                => self::GOOGLE_FONT,
			'Bungee Inline'                  => self::GOOGLE_FONT,
			'Bungee Outline'                 => self::GOOGLE_FONT,
			'Bungee Shade'                   => self::GOOGLE_FONT,
			'Butcherman'                     => self::GOOGLE_FONT,
			'Butterfly Kids'                 => self::GOOGLE_FONT,
			'Cabin'                          => self::GOOGLE_FONT,
			'Cabin Condensed'                => self::GOOGLE_FONT,
			'Cabin Sketch'                   => self::GOOGLE_FONT,
			'Caesar Dressing'                => self::GOOGLE_FONT,
			'Cagliostro'                     => self::GOOGLE_FONT,
			'Cairo'                          => self::GOOGLE_FONT,
			'Calligraffitti'                 => self::GOOGLE_FONT,
			'Cambay'                         => self::GOOGLE_FONT,
			'Cambo'                          => self::GOOGLE_FONT,
			'Candal'                         => self::GOOGLE_FONT,
			'Cantarell'                      => self::GOOGLE_FONT,
			'Cantata One'                    => self::GOOGLE_FONT,
			'Cantora One'                    => self::GOOGLE_FONT,
			'Capriola'                       => self::GOOGLE_FONT,
			'Cardo'                          => self::GOOGLE_FONT,
			'Carme'                          => self::GOOGLE_FONT,
			'Carrois Gothic'                 => self::GOOGLE_FONT,
			'Carrois Gothic SC'              => self::GOOGLE_FONT,
			'Carter One'                     => self::GOOGLE_FONT,
			'Catamaran'                      => self::GOOGLE_FONT,
			'Caudex'                         => self::GOOGLE_FONT,
			'Caveat'                         => self::GOOGLE_FONT,
			'Caveat Brush'                   => self::GOOGLE_FONT,
			'Cedarville Cursive'             => self::GOOGLE_FONT,
			'Ceviche One'                    => self::GOOGLE_FONT,
			'Chakra Petch'                   => self::GOOGLE_FONT,
			'Changa'                         => self::GOOGLE_FONT,
			'Changa One'                     => self::GOOGLE_FONT,
			'Chango'                         => self::GOOGLE_FONT,
			'Charmonman'                     => self::GOOGLE_FONT,
			'Chathura'                       => self::GOOGLE_FONT,
			'Chau Philomene One'             => self::GOOGLE_FONT,
			'Chela One'                      => self::GOOGLE_FONT,
			'Chelsea Market'                 => self::GOOGLE_FONT,
			'Chenla'                         => self::GOOGLE_FONT,
			'Cherry Cream Soda'              => self::GOOGLE_FONT,
			'Cherry Swash'                   => self::GOOGLE_FONT,
			'Chewy'                          => self::GOOGLE_FONT,
			'Chicle'                         => self::GOOGLE_FONT,
			'Chivo'                          => self::GOOGLE_FONT,
			'Chonburi'                       => self::GOOGLE_FONT,
			'Cinzel'                         => self::GOOGLE_FONT,
			'Cinzel Decorative'              => self::GOOGLE_FONT,
			'Clicker Script'                 => self::GOOGLE_FONT,
			'Coda'                           => self::GOOGLE_FONT,
			'Coda Caption'                   => self::GOOGLE_FONT,
			'Codystar'                       => self::GOOGLE_FONT,
			'Coiny'                          => self::GOOGLE_FONT,
			'Combo'                          => self::GOOGLE_FONT,
			'Comfortaa'                      => self::GOOGLE_FONT,
			'Coming Soon'                    => self::GOOGLE_FONT,
			'Concert One'                    => self::GOOGLE_FONT,
			'Condiment'                      => self::GOOGLE_FONT,
			'Content'                        => self::GOOGLE_FONT,
			'Contrail One'                   => self::GOOGLE_FONT,
			'Convergence'                    => self::GOOGLE_FONT,
			'Cookie'                         => self::GOOGLE_FONT,
			'Copse'                          => self::GOOGLE_FONT,
			'Corben'                         => self::GOOGLE_FONT,
			'Cormorant'                      => self::GOOGLE_FONT,
			'Cormorant Garamond'             => self::GOOGLE_FONT,
			'Cormorant Infant'               => self::GOOGLE_FONT,
			'Cormorant SC'                   => self::GOOGLE_FONT,
			'Cormorant Unicase'              => self::GOOGLE_FONT,
			'Cormorant Upright'              => self::GOOGLE_FONT,
			'Courgette'                      => self::GOOGLE_FONT,
			'Cousine'                        => self::GOOGLE_FONT,
			'Coustard'                       => self::GOOGLE_FONT,
			'Covered By Your Grace'          => self::GOOGLE_FONT,
			'Crafty Girls'                   => self::GOOGLE_FONT,
			'Creepster'                      => self::GOOGLE_FONT,
			'Crete Round'                    => self::GOOGLE_FONT,
			'Crimson Text'                   => self::GOOGLE_FONT,
			'Croissant One'                  => self::GOOGLE_FONT,
			'Crushed'                        => self::GOOGLE_FONT,
			'Cuprum'                         => self::GOOGLE_FONT,
			'Cute Font'                      => self::GOOGLE_FONT,
			'Cutive'                         => self::GOOGLE_FONT,
			'Cutive Mono'                    => self::GOOGLE_FONT,
			'Damion'                         => self::GOOGLE_FONT,
			'Dancing Script'                 => self::GOOGLE_FONT,
			'Dangrek'                        => self::GOOGLE_FONT,
			'David Libre'                    => self::GOOGLE_FONT,
			'Dawning of a New Day'           => self::GOOGLE_FONT,
			'Days One'                       => self::GOOGLE_FONT,
			'Dekko'                          => self::GOOGLE_FONT,
			'Delius'                         => self::GOOGLE_FONT,
			'Delius Swash Caps'              => self::GOOGLE_FONT,
			'Delius Unicase'                 => self::GOOGLE_FONT,
			'Della Respira'                  => self::GOOGLE_FONT,
			'Denk One'                       => self::GOOGLE_FONT,
			'Devonshire'                     => self::GOOGLE_FONT,
			'Dhurjati'                       => self::GOOGLE_FONT,
			'Didact Gothic'                  => self::GOOGLE_FONT,
			'Diplomata'                      => self::GOOGLE_FONT,
			'Diplomata SC'                   => self::GOOGLE_FONT,
			'Do Hyeon'                       => self::GOOGLE_FONT,
			'Dokdo'                          => self::GOOGLE_FONT,
			'Domine'                         => self::GOOGLE_FONT,
			'Donegal One'                    => self::GOOGLE_FONT,
			'Doppio One'                     => self::GOOGLE_FONT,
			'Dorsa'                          => self::GOOGLE_FONT,
			'Dosis'                          => self::GOOGLE_FONT,
			'Dr Sugiyama'                    => self::GOOGLE_FONT,
			'Duru Sans'                      => self::GOOGLE_FONT,
			'Dynalight'                      => self::GOOGLE_FONT,
			'EB Garamond'                    => self::GOOGLE_FONT,
			'Eagle Lake'                     => self::GOOGLE_FONT,
			'East Sea Dokdo'                 => self::GOOGLE_FONT,
			'Eater'                          => self::GOOGLE_FONT,
			'Economica'                      => self::GOOGLE_FONT,
			'Eczar'                          => self::GOOGLE_FONT,
			'El Messiri'                     => self::GOOGLE_FONT,
			'Electrolize'                    => self::GOOGLE_FONT,
			'Elsie'                          => self::GOOGLE_FONT,
			'Elsie Swash Caps'               => self::GOOGLE_FONT,
			'Emblema One'                    => self::GOOGLE_FONT,
			'Emilys Candy'                   => self::GOOGLE_FONT,
			'Encode Sans'                    => self::GOOGLE_FONT,
			'Encode Sans Condensed'          => self::GOOGLE_FONT,
			'Encode Sans Expanded'           => self::GOOGLE_FONT,
			'Encode Sans Semi Condensed'     => self::GOOGLE_FONT,
			'Encode Sans Semi Expanded'      => self::GOOGLE_FONT,
			'Engagement'                     => self::GOOGLE_FONT,
			'Englebert'                      => self::GOOGLE_FONT,
			'Enriqueta'                      => self::GOOGLE_FONT,
			'Erica One'                      => self::GOOGLE_FONT,
			'Esteban'                        => self::GOOGLE_FONT,
			'Euphoria Script'                => self::GOOGLE_FONT,
			'Ewert'                          => self::GOOGLE_FONT,
			'Exo'                            => self::GOOGLE_FONT,
			'Exo 2'                          => self::GOOGLE_FONT,
			'Expletus Sans'                  => self::GOOGLE_FONT,
			'Fahkwang'                       => self::GOOGLE_FONT,
			'Fanwood Text'                   => self::GOOGLE_FONT,
			'Farsan'                         => self::GOOGLE_FONT,
			'Fascinate'                      => self::GOOGLE_FONT,
			'Fascinate Inline'               => self::GOOGLE_FONT,
			'Faster One'                     => self::GOOGLE_FONT,
			'Fasthand'                       => self::GOOGLE_FONT,
			'Fauna One'                      => self::GOOGLE_FONT,
			'Faustina'                       => self::GOOGLE_FONT,
			'Federant'                       => self::GOOGLE_FONT,
			'Federo'                         => self::GOOGLE_FONT,
			'Felipa'                         => self::GOOGLE_FONT,
			'Fenix'                          => self::GOOGLE_FONT,
			'Finger Paint'                   => self::GOOGLE_FONT,
			'Fira Mono'                      => self::GOOGLE_FONT,
			'Fira Sans'                      => self::GOOGLE_FONT,
			'Fira Sans Condensed'            => self::GOOGLE_FONT,
			'Fira Sans Extra Condensed'      => self::GOOGLE_FONT,
			'Fjalla One'                     => self::GOOGLE_FONT,
			'Fjord One'                      => self::GOOGLE_FONT,
			'Flamenco'                       => self::GOOGLE_FONT,
			'Flavors'                        => self::GOOGLE_FONT,
			'Fondamento'                     => self::GOOGLE_FONT,
			'Fontdiner Swanky'               => self::GOOGLE_FONT,
			'Forum'                          => self::GOOGLE_FONT,
			'Francois One'                   => self::GOOGLE_FONT,
			'Frank Ruhl Libre'               => self::GOOGLE_FONT,
			'Freckle Face'                   => self::GOOGLE_FONT,
			'Fredericka the Great'           => self::GOOGLE_FONT,
			'Fredoka One'                    => self::GOOGLE_FONT,
			'Freehand'                       => self::GOOGLE_FONT,
			'Fresca'                         => self::GOOGLE_FONT,
			'Frijole'                        => self::GOOGLE_FONT,
			'Fruktur'                        => self::GOOGLE_FONT,
			'Fugaz One'                      => self::GOOGLE_FONT,
			'GFS Didot'                      => self::GOOGLE_FONT,
			'GFS Neohellenic'                => self::GOOGLE_FONT,
			'Gabriela'                       => self::GOOGLE_FONT,
			'Gaegu'                          => self::GOOGLE_FONT,
			'Gafata'                         => self::GOOGLE_FONT,
			'Galada'                         => self::GOOGLE_FONT,
			'Galdeano'                       => self::GOOGLE_FONT,
			'Galindo'                        => self::GOOGLE_FONT,
			'Gamja Flower'                   => self::GOOGLE_FONT,
			'Gentium Basic'                  => self::GOOGLE_FONT,
			'Gentium Book Basic'             => self::GOOGLE_FONT,
			'Geo'                            => self::GOOGLE_FONT,
			'Geostar'                        => self::GOOGLE_FONT,
			'Geostar Fill'                   => self::GOOGLE_FONT,
			'Germania One'                   => self::GOOGLE_FONT,
			'Gidugu'                         => self::GOOGLE_FONT,
			'Gilda Display'                  => self::GOOGLE_FONT,
			'Give You Glory'                 => self::GOOGLE_FONT,
			'Glass Antiqua'                  => self::GOOGLE_FONT,
			'Glegoo'                         => self::GOOGLE_FONT,
			'Gloria Hallelujah'              => self::GOOGLE_FONT,
			'Goblin One'                     => self::GOOGLE_FONT,
			'Gochi Hand'                     => self::GOOGLE_FONT,
			'Gorditas'                       => self::GOOGLE_FONT,
			'Gothic A1'                      => self::GOOGLE_FONT,
			'Goudy Bookletter 1911'          => self::GOOGLE_FONT,
			'Graduate'                       => self::GOOGLE_FONT,
			'Grand Hotel'                    => self::GOOGLE_FONT,
			'Gravitas One'                   => self::GOOGLE_FONT,
			'Great Vibes'                    => self::GOOGLE_FONT,
			'Griffy'                         => self::GOOGLE_FONT,
			'Gruppo'                         => self::GOOGLE_FONT,
			'Gudea'                          => self::GOOGLE_FONT,
			'Gugi'                           => self::GOOGLE_FONT,
			'Gurajada'                       => self::GOOGLE_FONT,
			'Habibi'                         => self::GOOGLE_FONT,
			'Halant'                         => self::GOOGLE_FONT,
			'Hammersmith One'                => self::GOOGLE_FONT,
			'Hanalei'                        => self::GOOGLE_FONT,
			'Hanalei Fill'                   => self::GOOGLE_FONT,
			'Handlee'                        => self::GOOGLE_FONT,
			'Hanuman'                        => self::GOOGLE_FONT,
			'Happy Monkey'                   => self::GOOGLE_FONT,
			'Harmattan'                      => self::GOOGLE_FONT,
			'Headland One'                   => self::GOOGLE_FONT,
			'Heebo'                          => self::GOOGLE_FONT,
			'Henny Penny'                    => self::GOOGLE_FONT,
			'Herr Von Muellerhoff'           => self::GOOGLE_FONT,
			'Hi Melody'                      => self::GOOGLE_FONT,
			'Hind'                           => self::GOOGLE_FONT,
			'Hind Guntur'                    => self::GOOGLE_FONT,
			'Hind Madurai'                   => self::GOOGLE_FONT,
			'Hind Siliguri'                  => self::GOOGLE_FONT,
			'Hind Vadodara'                  => self::GOOGLE_FONT,
			'Holtwood One SC'                => self::GOOGLE_FONT,
			'Homemade Apple'                 => self::GOOGLE_FONT,
			'Homenaje'                       => self::GOOGLE_FONT,
			'IBM Plex Mono'                  => self::GOOGLE_FONT,
			'IBM Plex Sans'                  => self::GOOGLE_FONT,
			'IBM Plex Sans Condensed'        => self::GOOGLE_FONT,
			'IBM Plex Serif'                 => self::GOOGLE_FONT,
			'IM Fell DW Pica'                => self::GOOGLE_FONT,
			'IM Fell DW Pica SC'             => self::GOOGLE_FONT,
			'IM Fell Double Pica'            => self::GOOGLE_FONT,
			'IM Fell Double Pica SC'         => self::GOOGLE_FONT,
			'IM Fell English'                => self::GOOGLE_FONT,
			'IM Fell English SC'             => self::GOOGLE_FONT,
			'IM Fell French Canon'           => self::GOOGLE_FONT,
			'IM Fell French Canon SC'        => self::GOOGLE_FONT,
			'IM Fell Great Primer'           => self::GOOGLE_FONT,
			'IM Fell Great Primer SC'        => self::GOOGLE_FONT,
			'Iceberg'                        => self::GOOGLE_FONT,
			'Iceland'                        => self::GOOGLE_FONT,
			'Imprima'                        => self::GOOGLE_FONT,
			'Inconsolata'                    => self::GOOGLE_FONT,
			'Inder'                          => self::GOOGLE_FONT,
			'Indie Flower'                   => self::GOOGLE_FONT,
			'Inika'                          => self::GOOGLE_FONT,
			'Inknut Antiqua'                 => self::GOOGLE_FONT,
			'Irish Grover'                   => self::GOOGLE_FONT,
			'Istok Web'                      => self::GOOGLE_FONT,
			'Italiana'                       => self::GOOGLE_FONT,
			'Italianno'                      => self::GOOGLE_FONT,
			'Itim'                           => self::GOOGLE_FONT,
			'Jacques Francois'               => self::GOOGLE_FONT,
			'Jacques Francois Shadow'        => self::GOOGLE_FONT,
			'Jaldi'                          => self::GOOGLE_FONT,
			'Jim Nightshade'                 => self::GOOGLE_FONT,
			'Jockey One'                     => self::GOOGLE_FONT,
			'Jolly Lodger'                   => self::GOOGLE_FONT,
			'Jomhuria'                       => self::GOOGLE_FONT,
			'Josefin Sans'                   => self::GOOGLE_FONT,
			'Josefin Slab'                   => self::GOOGLE_FONT,
			'Joti One'                       => self::GOOGLE_FONT,
			'Jua'                            => self::GOOGLE_FONT,
			'Judson'                         => self::GOOGLE_FONT,
			'Julee'                          => self::GOOGLE_FONT,
			'Julius Sans One'                => self::GOOGLE_FONT,
			'Junge'                          => self::GOOGLE_FONT,
			'Jura'                           => self::GOOGLE_FONT,
			'Just Another Hand'              => self::GOOGLE_FONT,
			'Just Me Again Down Here'        => self::GOOGLE_FONT,
			'K2D'                            => self::GOOGLE_FONT,
			'Kadwa'                          => self::GOOGLE_FONT,
			'Kalam'                          => self::GOOGLE_FONT,
			'Kameron'                        => self::GOOGLE_FONT,
			'Kanit'                          => self::GOOGLE_FONT,
			'Kantumruy'                      => self::GOOGLE_FONT,
			'Karla'                          => self::GOOGLE_FONT,
			'Karma'                          => self::GOOGLE_FONT,
			'Katibeh'                        => self::GOOGLE_FONT,
			'Kaushan Script'                 => self::GOOGLE_FONT,
			'Kavivanar'                      => self::GOOGLE_FONT,
			'Kavoon'                         => self::GOOGLE_FONT,
			'Kdam Thmor'                     => self::GOOGLE_FONT,
			'Keania One'                     => self::GOOGLE_FONT,
			'Kelly Slab'                     => self::GOOGLE_FONT,
			'Kenia'                          => self::GOOGLE_FONT,
			'Khand'                          => self::GOOGLE_FONT,
			'Khmer'                          => self::GOOGLE_FONT,
			'Khula'                          => self::GOOGLE_FONT,
			'Kirang Haerang'                 => self::GOOGLE_FONT,
			'Kite One'                       => self::GOOGLE_FONT,
			'Knewave'                        => self::GOOGLE_FONT,
			'KoHo'                           => self::GOOGLE_FONT,
			'Kodchasan'                      => self::GOOGLE_FONT,
			'Kosugi'                         => self::GOOGLE_FONT,
			'Kosugi Maru'                    => self::GOOGLE_FONT,
			'Kotta One'                      => self::GOOGLE_FONT,
			'Koulen'                         => self::GOOGLE_FONT,
			'Kranky'                         => self::GOOGLE_FONT,
			'Kreon'                          => self::GOOGLE_FONT,
			'Kristi'                         => self::GOOGLE_FONT,
			'Krona One'                      => self::GOOGLE_FONT,
			'Krub'                           => self::GOOGLE_FONT,
			'Kumar One'                      => self::GOOGLE_FONT,
			'Kumar One Outline'              => self::GOOGLE_FONT,
			'Kurale'                         => self::GOOGLE_FONT,
			'La Belle Aurore'                => self::GOOGLE_FONT,
			'Laila'                          => self::GOOGLE_FONT,
			'Lakki Reddy'                    => self::GOOGLE_FONT,
			'Lalezar'                        => self::GOOGLE_FONT,
			'Lancelot'                       => self::GOOGLE_FONT,
			'Lateef'                         => self::GOOGLE_FONT,
			'Lato'                           => self::GOOGLE_FONT,
			'League Script'                  => self::GOOGLE_FONT,
			'Leckerli One'                   => self::GOOGLE_FONT,
			'Ledger'                         => self::GOOGLE_FONT,
			'Lekton'                         => self::GOOGLE_FONT,
			'Lemon'                          => self::GOOGLE_FONT,
			'Lemonada'                       => self::GOOGLE_FONT,
			'Libre Barcode 128'              => self::GOOGLE_FONT,
			'Libre Barcode 128 Text'         => self::GOOGLE_FONT,
			'Libre Barcode 39'               => self::GOOGLE_FONT,
			'Libre Barcode 39 Extended'      => self::GOOGLE_FONT,
			'Libre Barcode 39 Extended Text' => self::GOOGLE_FONT,
			'Libre Barcode 39 Text'          => self::GOOGLE_FONT,
			'Libre Baskerville'              => self::GOOGLE_FONT,
			'Libre Franklin'                 => self::GOOGLE_FONT,
			'Life Savers'                    => self::GOOGLE_FONT,
			'Lilita One'                     => self::GOOGLE_FONT,
			'Lily Script One'                => self::GOOGLE_FONT,
			'Limelight'                      => self::GOOGLE_FONT,
			'Linden Hill'                    => self::GOOGLE_FONT,
			'Lobster'                        => self::GOOGLE_FONT,
			'Lobster Two'                    => self::GOOGLE_FONT,
			'Londrina Outline'               => self::GOOGLE_FONT,
			'Londrina Shadow'                => self::GOOGLE_FONT,
			'Londrina Sketch'                => self::GOOGLE_FONT,
			'Londrina Solid'                 => self::GOOGLE_FONT,
			'Lora'                           => self::GOOGLE_FONT,
			'Love Ya Like A Sister'          => self::GOOGLE_FONT,
			'Loved by the King'              => self::GOOGLE_FONT,
			'Lovers Quarrel'                 => self::GOOGLE_FONT,
			'Luckiest Guy'                   => self::GOOGLE_FONT,
			'Lusitana'                       => self::GOOGLE_FONT,
			'Lustria'                        => self::GOOGLE_FONT,
			'M PLUS 1p'                      => self::GOOGLE_FONT,
			'M PLUS Rounded 1c'              => self::GOOGLE_FONT,
			'Macondo'                        => self::GOOGLE_FONT,
			'Macondo Swash Caps'             => self::GOOGLE_FONT,
			'Mada'                           => self::GOOGLE_FONT,
			'Magra'                          => self::GOOGLE_FONT,
			'Maiden Orange'                  => self::GOOGLE_FONT,
			'Maitree'                        => self::GOOGLE_FONT,
			'Mako'                           => self::GOOGLE_FONT,
			'Mali'                           => self::GOOGLE_FONT,
			'Mallanna'                       => self::GOOGLE_FONT,
			'Mandali'                        => self::GOOGLE_FONT,
			'Manuale'                        => self::GOOGLE_FONT,
			'Marcellus'                      => self::GOOGLE_FONT,
			'Marcellus SC'                   => self::GOOGLE_FONT,
			'Marck Script'                   => self::GOOGLE_FONT,
			'Margarine'                      => self::GOOGLE_FONT,
			'Markazi Text'                   => self::GOOGLE_FONT,
			'Marko One'                      => self::GOOGLE_FONT,
			'Marmelad'                       => self::GOOGLE_FONT,
			'Martel'                         => self::GOOGLE_FONT,
			'Martel Sans'                    => self::GOOGLE_FONT,
			'Marvel'                         => self::GOOGLE_FONT,
			'Mate'                           => self::GOOGLE_FONT,
			'Mate SC'                        => self::GOOGLE_FONT,
			'Maven Pro'                      => self::GOOGLE_FONT,
			'McLaren'                        => self::GOOGLE_FONT,
			'Meddon'                         => self::GOOGLE_FONT,
			'MedievalSharp'                  => self::GOOGLE_FONT,
			'Medula One'                     => self::GOOGLE_FONT,
			'Meera Inimai'                   => self::GOOGLE_FONT,
			'Megrim'                         => self::GOOGLE_FONT,
			'Meie Script'                    => self::GOOGLE_FONT,
			'Merienda'                       => self::GOOGLE_FONT,
			'Merienda One'                   => self::GOOGLE_FONT,
			'Merriweather'                   => self::GOOGLE_FONT,
			'Merriweather Sans'              => self::GOOGLE_FONT,
			'Metal'                          => self::GOOGLE_FONT,
			'Metal Mania'                    => self::GOOGLE_FONT,
			'Metamorphous'                   => self::GOOGLE_FONT,
			'Metrophobic'                    => self::GOOGLE_FONT,
			'Michroma'                       => self::GOOGLE_FONT,
			'Milonga'                        => self::GOOGLE_FONT,
			'Miltonian'                      => self::GOOGLE_FONT,
			'Miltonian Tattoo'               => self::GOOGLE_FONT,
			'Mina'                           => self::GOOGLE_FONT,
			'Miniver'                        => self::GOOGLE_FONT,
			'Miriam Libre'                   => self::GOOGLE_FONT,
			'Mirza'                          => self::GOOGLE_FONT,
			'Miss Fajardose'                 => self::GOOGLE_FONT,
			'Mitr'                           => self::GOOGLE_FONT,
			'Modak'                          => self::GOOGLE_FONT,
			'Modern Antiqua'                 => self::GOOGLE_FONT,
			'Mogra'                          => self::GOOGLE_FONT,
			'Molengo'                        => self::GOOGLE_FONT,
			'Molle'                          => self::GOOGLE_FONT,
			'Monda'                          => self::GOOGLE_FONT,
			'Monofett'                       => self::GOOGLE_FONT,
			'Monoton'                        => self::GOOGLE_FONT,
			'Monsieur La Doulaise'           => self::GOOGLE_FONT,
			'Montaga'                        => self::GOOGLE_FONT,
			'Montez'                         => self::GOOGLE_FONT,
			'Montserrat'                     => self::GOOGLE_FONT,
			'Montserrat Alternates'          => self::GOOGLE_FONT,
			'Montserrat Subrayada'           => self::GOOGLE_FONT,
			'Moul'                           => self::GOOGLE_FONT,
			'Moulpali'                       => self::GOOGLE_FONT,
			'Mountains of Christmas'         => self::GOOGLE_FONT,
			'Mouse Memoirs'                  => self::GOOGLE_FONT,
			'Mr Bedfort'                     => self::GOOGLE_FONT,
			'Mr Dafoe'                       => self::GOOGLE_FONT,
			'Mr De Haviland'                 => self::GOOGLE_FONT,
			'Mrs Saint Delafield'            => self::GOOGLE_FONT,
			'Mrs Sheppards'                  => self::GOOGLE_FONT,
			'Mukta'                          => self::GOOGLE_FONT,
			'Mukta Mahee'                    => self::GOOGLE_FONT,
			'Mukta Malar'                    => self::GOOGLE_FONT,
			'Mukta Vaani'                    => self::GOOGLE_FONT,
			'Muli'                           => self::GOOGLE_FONT,
			'Mystery Quest'                  => self::GOOGLE_FONT,
			'NTR'                            => self::GOOGLE_FONT,
			'Nanum Brush Script'             => self::GOOGLE_FONT,
			'Nanum Gothic'                   => self::GOOGLE_FONT,
			'Nanum Gothic Coding'            => self::GOOGLE_FONT,
			'Nanum Myeongjo'                 => self::GOOGLE_FONT,
			'Nanum Pen Script'               => self::GOOGLE_FONT,
			'Neucha'                         => self::GOOGLE_FONT,
			'Neuton'                         => self::GOOGLE_FONT,
			'New Rocker'                     => self::GOOGLE_FONT,
			'News Cycle'                     => self::GOOGLE_FONT,
			'Niconne'                        => self::GOOGLE_FONT,
			'Niramit'                        => self::GOOGLE_FONT,
			'Nixie One'                      => self::GOOGLE_FONT,
			'Nobile'                         => self::GOOGLE_FONT,
			'Nokora'                         => self::GOOGLE_FONT,
			'Norican'                        => self::GOOGLE_FONT,
			'Nosifer'                        => self::GOOGLE_FONT,
			'Notable'                        => self::GOOGLE_FONT,
			'Nothing You Could Do'           => self::GOOGLE_FONT,
			'Noticia Text'                   => self::GOOGLE_FONT,
			'Noto Sans'                      => self::GOOGLE_FONT,
			'Noto Sans JP'                   => self::GOOGLE_FONT,
			'Noto Sans KR'                   => self::GOOGLE_FONT,
			'Noto Serif'                     => self::GOOGLE_FONT,
			'Noto Serif JP'                  => self::GOOGLE_FONT,
			'Noto Serif KR'                  => self::GOOGLE_FONT,
			'Nova Cut'                       => self::GOOGLE_FONT,
			'Nova Flat'                      => self::GOOGLE_FONT,
			'Nova Mono'                      => self::GOOGLE_FONT,
			'Nova Oval'                      => self::GOOGLE_FONT,
			'Nova Round'                     => self::GOOGLE_FONT,
			'Nova Script'                    => self::GOOGLE_FONT,
			'Nova Slim'                      => self::GOOGLE_FONT,
			'Nova Square'                    => self::GOOGLE_FONT,
			'Numans'                         => self::GOOGLE_FONT,
			'Nunito'                         => self::GOOGLE_FONT,
			'Nunito Sans'                    => self::GOOGLE_FONT,
			'Odor Mean Chey'                 => self::GOOGLE_FONT,
			'Offside'                        => self::GOOGLE_FONT,
			'Old Standard TT'                => self::GOOGLE_FONT,
			'Oldenburg'                      => self::GOOGLE_FONT,
			'Oleo Script'                    => self::GOOGLE_FONT,
			'Oleo Script Swash Caps'         => self::GOOGLE_FONT,
			'Open Sans'                      => self::GOOGLE_FONT,
			'Open Sans Condensed'            => self::GOOGLE_FONT,
			'Oranienbaum'                    => self::GOOGLE_FONT,
			'Orbitron'                       => self::GOOGLE_FONT,
			'Oregano'                        => self::GOOGLE_FONT,
			'Orienta'                        => self::GOOGLE_FONT,
			'Original Surfer'                => self::GOOGLE_FONT,
			'Oswald'                         => self::GOOGLE_FONT,
			'Over the Rainbow'               => self::GOOGLE_FONT,
			'Overlock'                       => self::GOOGLE_FONT,
			'Overlock SC'                    => self::GOOGLE_FONT,
			'Overpass'                       => self::GOOGLE_FONT,
			'Overpass Mono'                  => self::GOOGLE_FONT,
			'Ovo'                            => self::GOOGLE_FONT,
			'Oxygen'                         => self::GOOGLE_FONT,
			'Oxygen Mono'                    => self::GOOGLE_FONT,
			'PT Mono'                        => self::GOOGLE_FONT,
			'PT Sans'                        => self::GOOGLE_FONT,
			'PT Sans Caption'                => self::GOOGLE_FONT,
			'PT Sans Narrow'                 => self::GOOGLE_FONT,
			'PT Serif'                       => self::GOOGLE_FONT,
			'PT Serif Caption'               => self::GOOGLE_FONT,
			'Pacifico'                       => self::GOOGLE_FONT,
			'Padauk'                         => self::GOOGLE_FONT,
			'Palanquin'                      => self::GOOGLE_FONT,
			'Palanquin Dark'                 => self::GOOGLE_FONT,
			'Pangolin'                       => self::GOOGLE_FONT,
			'Paprika'                        => self::GOOGLE_FONT,
			'Parisienne'                     => self::GOOGLE_FONT,
			'Passero One'                    => self::GOOGLE_FONT,
			'Passion One'                    => self::GOOGLE_FONT,
			'Pathway Gothic One'             => self::GOOGLE_FONT,
			'Patrick Hand'                   => self::GOOGLE_FONT,
			'Patrick Hand SC'                => self::GOOGLE_FONT,
			'Pattaya'                        => self::GOOGLE_FONT,
			'Patua One'                      => self::GOOGLE_FONT,
			'Pavanam'                        => self::GOOGLE_FONT,
			'Paytone One'                    => self::GOOGLE_FONT,
			'Peddana'                        => self::GOOGLE_FONT,
			'Peralta'                        => self::GOOGLE_FONT,
			'Permanent Marker'               => self::GOOGLE_FONT,
			'Petit Formal Script'            => self::GOOGLE_FONT,
			'Petrona'                        => self::GOOGLE_FONT,
			'Philosopher'                    => self::GOOGLE_FONT,
			'Piedra'                         => self::GOOGLE_FONT,
			'Pinyon Script'                  => self::GOOGLE_FONT,
			'Pirata One'                     => self::GOOGLE_FONT,
			'Plaster'                        => self::GOOGLE_FONT,
			'Play'                           => self::GOOGLE_FONT,
			'Playball'                       => self::GOOGLE_FONT,
			'Playfair Display'               => self::GOOGLE_FONT,
			'Playfair Display SC'            => self::GOOGLE_FONT,
			'Podkova'                        => self::GOOGLE_FONT,
			'Poiret One'                     => self::GOOGLE_FONT,
			'Poller One'                     => self::GOOGLE_FONT,
			'Poly'                           => self::GOOGLE_FONT,
			'Pompiere'                       => self::GOOGLE_FONT,
			'Pontano Sans'                   => self::GOOGLE_FONT,
			'Poor Story'                     => self::GOOGLE_FONT,
			'Poppins'                        => self::GOOGLE_FONT,
			'Port Lligat Sans'               => self::GOOGLE_FONT,
			'Port Lligat Slab'               => self::GOOGLE_FONT,
			'Pragati Narrow'                 => self::GOOGLE_FONT,
			'Prata'                          => self::GOOGLE_FONT,
			'Preahvihear'                    => self::GOOGLE_FONT,
			'Press Start 2P'                 => self::GOOGLE_FONT,
			'Pridi'                          => self::GOOGLE_FONT,
			'Princess Sofia'                 => self::GOOGLE_FONT,
			'Prociono'                       => self::GOOGLE_FONT,
			'Prompt'                         => self::GOOGLE_FONT,
			'Prosto One'                     => self::GOOGLE_FONT,
			'Proza Libre'                    => self::GOOGLE_FONT,
			'Puritan'                        => self::GOOGLE_FONT,
			'Purple Purse'                   => self::GOOGLE_FONT,
			'Quando'                         => self::GOOGLE_FONT,
			'Quantico'                       => self::GOOGLE_FONT,
			'Quattrocento'                   => self::GOOGLE_FONT,
			'Quattrocento Sans'              => self::GOOGLE_FONT,
			'Questrial'                      => self::GOOGLE_FONT,
			'Quicksand'                      => self::GOOGLE_FONT,
			'Quintessential'                 => self::GOOGLE_FONT,
			'Qwigley'                        => self::GOOGLE_FONT,
			'Racing Sans One'                => self::GOOGLE_FONT,
			'Radley'                         => self::GOOGLE_FONT,
			'Rajdhani'                       => self::GOOGLE_FONT,
			'Rakkas'                         => self::GOOGLE_FONT,
			'Raleway'                        => self::GOOGLE_FONT,
			'Raleway Dots'                   => self::GOOGLE_FONT,
			'Ramabhadra'                     => self::GOOGLE_FONT,
			'Ramaraja'                       => self::GOOGLE_FONT,
			'Rambla'                         => self::GOOGLE_FONT,
			'Rammetto One'                   => self::GOOGLE_FONT,
			'Ranchers'                       => self::GOOGLE_FONT,
			'Rancho'                         => self::GOOGLE_FONT,
			'Ranga'                          => self::GOOGLE_FONT,
			'Rasa'                           => self::GOOGLE_FONT,
			'Rationale'                      => self::GOOGLE_FONT,
			'Ravi Prakash'                   => self::GOOGLE_FONT,
			'Redressed'                      => self::GOOGLE_FONT,
			'Reem Kufi'                      => self::GOOGLE_FONT,
			'Reenie Beanie'                  => self::GOOGLE_FONT,
			'Revalia'                        => self::GOOGLE_FONT,
			'Rhodium Libre'                  => self::GOOGLE_FONT,
			'Ribeye'                         => self::GOOGLE_FONT,
			'Ribeye Marrow'                  => self::GOOGLE_FONT,
			'Righteous'                      => self::GOOGLE_FONT,
			'Risque'                         => self::GOOGLE_FONT,
			'Roboto'                         => self::GOOGLE_FONT,
			'Roboto Condensed'               => self::GOOGLE_FONT,
			'Roboto Mono'                    => self::GOOGLE_FONT,
			'Roboto Slab'                    => self::GOOGLE_FONT,
			'Rochester'                      => self::GOOGLE_FONT,
			'Rock Salt'                      => self::GOOGLE_FONT,
			'Rokkitt'                        => self::GOOGLE_FONT,
			'Romanesco'                      => self::GOOGLE_FONT,
			'Ropa Sans'                      => self::GOOGLE_FONT,
			'Rosario'                        => self::GOOGLE_FONT,
			'Rosarivo'                       => self::GOOGLE_FONT,
			'Rouge Script'                   => self::GOOGLE_FONT,
			'Rozha One'                      => self::GOOGLE_FONT,
			'Rubik'                          => self::GOOGLE_FONT,
			'Rubik Mono One'                 => self::GOOGLE_FONT,
			'Ruda'                           => self::GOOGLE_FONT,
			'Rufina'                         => self::GOOGLE_FONT,
			'Ruge Boogie'                    => self::GOOGLE_FONT,
			'Ruluko'                         => self::GOOGLE_FONT,
			'Rum Raisin'                     => self::GOOGLE_FONT,
			'Ruslan Display'                 => self::GOOGLE_FONT,
			'Russo One'                      => self::GOOGLE_FONT,
			'Ruthie'                         => self::GOOGLE_FONT,
			'Rye'                            => self::GOOGLE_FONT,
			'Sacramento'                     => self::GOOGLE_FONT,
			'Sahitya'                        => self::GOOGLE_FONT,
			'Sail'                           => self::GOOGLE_FONT,
			'Saira'                          => self::GOOGLE_FONT,
			'Saira Condensed'                => self::GOOGLE_FONT,
			'Saira Extra Condensed'          => self::GOOGLE_FONT,
			'Saira Semi Condensed'           => self::GOOGLE_FONT,
			'Salsa'                          => self::GOOGLE_FONT,
			'Sanchez'                        => self::GOOGLE_FONT,
			'Sancreek'                       => self::GOOGLE_FONT,
			'Sansita'                        => self::GOOGLE_FONT,
			'Sarala'                         => self::GOOGLE_FONT,
			'Sarina'                         => self::GOOGLE_FONT,
			'Sarpanch'                       => self::GOOGLE_FONT,
			'Satisfy'                        => self::GOOGLE_FONT,
			'Sawarabi Gothic'                => self::GOOGLE_FONT,
			'Sawarabi Mincho'                => self::GOOGLE_FONT,
			'Scada'                          => self::GOOGLE_FONT,
			'Scheherazade'                   => self::GOOGLE_FONT,
			'Schoolbell'                     => self::GOOGLE_FONT,
			'Scope One'                      => self::GOOGLE_FONT,
			'Seaweed Script'                 => self::GOOGLE_FONT,
			'Secular One'                    => self::GOOGLE_FONT,
			'Sedgwick Ave'                   => self::GOOGLE_FONT,
			'Sedgwick Ave Display'           => self::GOOGLE_FONT,
			'Sevillana'                      => self::GOOGLE_FONT,
			'Seymour One'                    => self::GOOGLE_FONT,
			'Shadows Into Light'             => self::GOOGLE_FONT,
			'Shadows Into Light Two'         => self::GOOGLE_FONT,
			'Shanti'                         => self::GOOGLE_FONT,
			'Share'                          => self::GOOGLE_FONT,
			'Share Tech'                     => self::GOOGLE_FONT,
			'Share Tech Mono'                => self::GOOGLE_FONT,
			'Shojumaru'                      => self::GOOGLE_FONT,
			'Short Stack'                    => self::GOOGLE_FONT,
			'Shrikhand'                      => self::GOOGLE_FONT,
			'Siemreap'                       => self::GOOGLE_FONT,
			'Sigmar One'                     => self::GOOGLE_FONT,
			'Signika'                        => self::GOOGLE_FONT,
			'Signika Negative'               => self::GOOGLE_FONT,
			'Simonetta'                      => self::GOOGLE_FONT,
			'Sintony'                        => self::GOOGLE_FONT,
			'Sirin Stencil'                  => self::GOOGLE_FONT,
			'Six Caps'                       => self::GOOGLE_FONT,
			'Skranji'                        => self::GOOGLE_FONT,
			'Slabo 13px'                     => self::GOOGLE_FONT,
			'Slabo 27px'                     => self::GOOGLE_FONT,
			'Slackey'                        => self::GOOGLE_FONT,
			'Smokum'                         => self::GOOGLE_FONT,
			'Smythe'                         => self::GOOGLE_FONT,
			'Sniglet'                        => self::GOOGLE_FONT,
			'Snippet'                        => self::GOOGLE_FONT,
			'Snowburst One'                  => self::GOOGLE_FONT,
			'Sofadi One'                     => self::GOOGLE_FONT,
			'Sofia'                          => self::GOOGLE_FONT,
			'Song Myung'                     => self::GOOGLE_FONT,
			'Sonsie One'                     => self::GOOGLE_FONT,
			'Sorts Mill Goudy'               => self::GOOGLE_FONT,
			'Source Code Pro'                => self::GOOGLE_FONT,
			'Source Sans Pro'                => self::GOOGLE_FONT,
			'Source Serif Pro'               => self::GOOGLE_FONT,
			'Space Mono'                     => self::GOOGLE_FONT,
			'Special Elite'                  => self::GOOGLE_FONT,
			'Spectral'                       => self::GOOGLE_FONT,
			'Spectral SC'                    => self::GOOGLE_FONT,
			'Spicy Rice'                     => self::GOOGLE_FONT,
			'Spinnaker'                      => self::GOOGLE_FONT,
			'Spirax'                         => self::GOOGLE_FONT,
			'Squada One'                     => self::GOOGLE_FONT,
			'Sree Krushnadevaraya'           => self::GOOGLE_FONT,
			'Sriracha'                       => self::GOOGLE_FONT,
			'Srisakdi'                       => self::GOOGLE_FONT,
			'Stalemate'                      => self::GOOGLE_FONT,
			'Stalinist One'                  => self::GOOGLE_FONT,
			'Stardos Stencil'                => self::GOOGLE_FONT,
			'Stint Ultra Condensed'          => self::GOOGLE_FONT,
			'Stint Ultra Expanded'           => self::GOOGLE_FONT,
			'Stoke'                          => self::GOOGLE_FONT,
			'Strait'                         => self::GOOGLE_FONT,
			'Stylish'                        => self::GOOGLE_FONT,
			'Sue Ellen Francisco'            => self::GOOGLE_FONT,
			'Suez One'                       => self::GOOGLE_FONT,
			'Sumana'                         => self::GOOGLE_FONT,
			'Sunflower'                      => self::GOOGLE_FONT,
			'Sunshiney'                      => self::GOOGLE_FONT,
			'Supermercado One'               => self::GOOGLE_FONT,
			'Sura'                           => self::GOOGLE_FONT,
			'Suranna'                        => self::GOOGLE_FONT,
			'Suravaram'                      => self::GOOGLE_FONT,
			'Suwannaphum'                    => self::GOOGLE_FONT,
			'Swanky and Moo Moo'             => self::GOOGLE_FONT,
			'Syncopate'                      => self::GOOGLE_FONT,
			'Tajawal'                        => self::GOOGLE_FONT,
			'Tangerine'                      => self::GOOGLE_FONT,
			'Taprom'                         => self::GOOGLE_FONT,
			'Tauri'                          => self::GOOGLE_FONT,
			'Taviraj'                        => self::GOOGLE_FONT,
			'Teko'                           => self::GOOGLE_FONT,
			'Telex'                          => self::GOOGLE_FONT,
			'Tenali Ramakrishna'             => self::GOOGLE_FONT,
			'Tenor Sans'                     => self::GOOGLE_FONT,
			'Text Me One'                    => self::GOOGLE_FONT,
			'The Girl Next Door'             => self::GOOGLE_FONT,
			'Tienne'                         => self::GOOGLE_FONT,
			'Tillana'                        => self::GOOGLE_FONT,
			'Timmana'                        => self::GOOGLE_FONT,
			'Tinos'                          => self::GOOGLE_FONT,
			'Titan One'                      => self::GOOGLE_FONT,
			'Titillium Web'                  => self::GOOGLE_FONT,
			'Trade Winds'                    => self::GOOGLE_FONT,
			'Trirong'                        => self::GOOGLE_FONT,
			'Trocchi'                        => self::GOOGLE_FONT,
			'Trochut'                        => self::GOOGLE_FONT,
			'Trykker'                        => self::GOOGLE_FONT,
			'Tulpen One'                     => self::GOOGLE_FONT,
			'Ubuntu'                         => self::GOOGLE_FONT,
			'Ubuntu Condensed'               => self::GOOGLE_FONT,
			'Ubuntu Mono'                    => self::GOOGLE_FONT,
			'Ultra'                          => self::GOOGLE_FONT,
			'Uncial Antiqua'                 => self::GOOGLE_FONT,
			'Underdog'                       => self::GOOGLE_FONT,
			'Unica One'                      => self::GOOGLE_FONT,
			'UnifrakturCook'                 => self::GOOGLE_FONT,
			'UnifrakturMaguntia'             => self::GOOGLE_FONT,
			'Unkempt'                        => self::GOOGLE_FONT,
			'Unlock'                         => self::GOOGLE_FONT,
			'Unna'                           => self::GOOGLE_FONT,
			'VT323'                          => self::GOOGLE_FONT,
			'Vampiro One'                    => self::GOOGLE_FONT,
			'Varela'                         => self::GOOGLE_FONT,
			'Varela Round'                   => self::GOOGLE_FONT,
			'Vast Shadow'                    => self::GOOGLE_FONT,
			'Vesper Libre'                   => self::GOOGLE_FONT,
			'Vibur'                          => self::GOOGLE_FONT,
			'Vidaloka'                       => self::GOOGLE_FONT,
			'Viga'                           => self::GOOGLE_FONT,
			'Voces'                          => self::GOOGLE_FONT,
			'Volkhov'                        => self::GOOGLE_FONT,
			'Vollkorn'                       => self::GOOGLE_FONT,
			'Vollkorn SC'                    => self::GOOGLE_FONT,
			'Voltaire'                       => self::GOOGLE_FONT,
			'Waiting for the Sunrise'        => self::GOOGLE_FONT,
			'Wallpoet'                       => self::GOOGLE_FONT,
			'Walter Turncoat'                => self::GOOGLE_FONT,
			'Warnes'                         => self::GOOGLE_FONT,
			'Wellfleet'                      => self::GOOGLE_FONT,
			'Wendy One'                      => self::GOOGLE_FONT,
			'Wire One'                       => self::GOOGLE_FONT,
			'Work Sans'                      => self::GOOGLE_FONT,
			'Yanone Kaffeesatz'              => self::GOOGLE_FONT,
			'Yantramanav'                    => self::GOOGLE_FONT,
			'Yatra One'                      => self::GOOGLE_FONT,
			'Yellowtail'                     => self::GOOGLE_FONT,
			'Yeon Sung'                      => self::GOOGLE_FONT,
			'Yeseva One'                     => self::GOOGLE_FONT,
			'Yesteryear'                     => self::GOOGLE_FONT,
			'Yrsa'                           => self::GOOGLE_FONT,
			'Zeyada'                         => self::GOOGLE_FONT,
			'Zilla Slab'                     => self::GOOGLE_FONT,
			'Zilla Slab Highlight'           => self::GOOGLE_FONT,
		);

		return apply_filters( 'gutenverse_fonts', $fonts );
	}

	/**
	 * Get font weights
	 *
	 * @return mixed
	 */
	public function get_font_weights() {
		$weights = array(
			'normal' => esc_html__( 'Normal', 'gutenverse' ),
			'bold'   => esc_html__( 'Bold', 'gutenverse' ),
			'100'    => '100',
			'200'    => '200',
			'300'    => '300',
			'400'    => '400',
			'500'    => '500',
			'600'    => '600',
			'700'    => '700',
			'800'    => '800',
			'900'    => '900',
		);

		return apply_filters( 'gutenverse_font_weight', $weights );
	}

	/**
	 * Get Font Settings
	 *
	 * @return mixed
	 */
	public function get_font_styles() {
		$styles = array(
			'normal' => esc_html__( 'Normal', 'gutenverse' ),
			'italic' => esc_html__( 'Italic', 'gutenverse' ),
		);

		return apply_filters( 'gutenverse_font_styles', $styles );
	}

	/**
	 * Get Font Settings
	 *
	 * @return mixed
	 */
	public function get_font_transform() {
		$styles = array(
			'uppercase'  => esc_html__( 'Uppercase', 'gutenverse' ),
			'capitalize' => esc_html__( 'Capitalize', 'gutenverse' ),
			'lowercase'  => esc_html__( 'Lowercase', 'gutenverse' ),
			'none'       => esc_html__( 'None', 'gutenverse' ),
		);

		return apply_filters( 'gutenverse_font_transform', $styles );
	}

	/**
	 * Get Font Settings
	 *
	 * @return array
	 */
	public function get_font_settings() {
		$data              = array();
		$data['fonts']     = array();
		$data['groups']    = array();
		$data['weights']   = $this->get_font_weights();
		$data['styles']    = $this->get_font_styles();
		$data['transform'] = $this->get_font_transform();

		$fonts = $this->get_fonts();
		foreach ( $fonts as $font => $group ) {
			$data['fonts'][] = array(
				'class' => $group,
				'value' => $font,
				'name'  => $font,
			);
		}

		$groups = $this->get_font_groups();
		foreach ( $groups as $id => $group ) {
			$data['groups'][] = array(
				'value' => $id,
				'label' => $group,
			);
		}

		return $data;
	}

}
